/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.message;

import filenet.vw.api.VWValidationError;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.VWValidationToolTip;
import filenet.vw.toolkit.design.message.images.VWImageLoader;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class VWValidationErrorLevelTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private ImageIcon m_errorIcon = null;
    private ImageIcon m_warningIcon = null;

    public VWValidationErrorLevelTableCellRenderer() {
        try {
            this.setOpaque(true);
            this.m_errorIcon = VWImageLoader.createImageIcon("error.gif");
            this.m_warningIcon = VWImageLoader.createImageIcon("warning.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ImageIcon icon = null;
        VWValidationError error = (VWValidationError)value;
        if (error != null) {
            switch (error.getLevel()) {
                case 1: {
                    icon = this.m_errorIcon;
                    break;
                }
                case 2: {
                    icon = this.m_warningIcon;
                }
            }
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setIcon(icon);
        this.setText(null);
        this.setToolTipText(VWValidationToolTip.createValidationToolTip(error));
        return this;
    }
}

